/*
 * Decompiled with CFR 0.152.
 */
package gcad;

import gcad.Clone;
import gcad.CloneClass;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneClassList {
    private String system;
    private String granularity;
    private String threshold;
    private int minLine;
    private int maxLines;
    private int npcs;
    private int nclones;
    private int nfragments;
    private int npairs;
    private int nclasses;
    private long ncompares;
    private long cputime;
    private ArrayList cloneClassList;
    public static Document document;
    Map<Integer, List<Integer>> hmByGID = new HashMap<Integer, List<Integer>>();
    Map<Integer, Integer> hmByPCID = new HashMap<Integer, Integer>();

    public CloneClassList() {
        this.cloneClassList = new ArrayList();
    }

    public void initialize(File f) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        try {
            document = builder.parse(f);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        document.getDocumentElement().normalize();
        this.readSysteminfo(document);
        this.readClassinfo(document);
        this.readRuninfo(document);
        this.readClonesClass(document);
    }

    private void readSysteminfo(Document d) {
        NodeList nodeList = d.getElementsByTagName("systeminfo");
        NamedNodeMap attributeNodes = nodeList.item(0).getAttributes();
        this.setSystem(attributeNodes.getNamedItem("system").getNodeValue());
        this.setGranularity(attributeNodes.getNamedItem("granularity").getNodeValue());
        this.setThreshold(attributeNodes.getNamedItem("threshold").getNodeValue());
        this.setMinLine(Integer.parseInt(attributeNodes.getNamedItem("minlines").getNodeValue()));
        this.setMaxLines(Integer.parseInt(attributeNodes.getNamedItem("maxlines").getNodeValue()));
    }

    private void readClassinfo(Document d) {
        NodeList nodeList = d.getElementsByTagName("classinfo");
        NamedNodeMap attributeNodes = nodeList.item(0).getAttributes();
        this.setNpcs(Integer.parseInt(attributeNodes.getNamedItem("npcs").getNodeValue()));
        this.setNclones(Integer.parseInt(attributeNodes.getNamedItem("nclones").getNodeValue()));
        this.setNfragments(Integer.parseInt(attributeNodes.getNamedItem("nfragments").getNodeValue()));
        this.setNpairs(Integer.parseInt(attributeNodes.getNamedItem("npairs").getNodeValue()));
        this.setNclasses(Integer.parseInt(attributeNodes.getNamedItem("nclasses").getNodeValue()));
    }

    private void readRuninfo(Document d) {
        NodeList nodeList = d.getElementsByTagName("runinfo");
        NamedNodeMap attributeNodes = nodeList.item(0).getAttributes();
        this.setNcompares(Long.parseLong(attributeNodes.getNamedItem("ncompares").getNodeValue()));
        this.setCputime(Long.parseLong(attributeNodes.getNamedItem("cputime").getNodeValue()));
    }

    private void readClonesClass(Document d) {
        int numOfClones = 0;
        CloneClass cloneClass = null;
        NodeList nodeList = d.getElementsByTagName("class");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ArrayList<Integer> a = new ArrayList<Integer>();
            NamedNodeMap attributeNodes = nodeList.item(i).getAttributes();
            int id = Integer.parseInt(attributeNodes.getNamedItem("id").getNodeValue());
            int nlines = Integer.parseInt(attributeNodes.getNamedItem("nlines").getNodeValue());
            int nfragments = Integer.parseInt(attributeNodes.getNamedItem("nfragments").getNodeValue());
            cloneClass = new CloneClass(id, nlines, nfragments);
            nodeList.item(i).normalize();
            NodeList secondaryNodeList = nodeList.item(i).getChildNodes();
            for (int j = 0; j < secondaryNodeList.getLength(); ++j) {
                if (secondaryNodeList.item(j).getNodeType() != 1) continue;
                NamedNodeMap secondaryAttributeNodes = secondaryNodeList.item(j).getAttributes();
                String file = secondaryAttributeNodes.getNamedItem("file").getNodeValue();
                int startLine = Integer.parseInt(secondaryAttributeNodes.getNamedItem("startline").getNodeValue());
                int endLine = Integer.parseInt(secondaryAttributeNodes.getNamedItem("endline").getNodeValue());
                int pcid = Integer.parseInt(secondaryAttributeNodes.getNamedItem("pcid").getNodeValue());
                cloneClass.addClone(new Clone(startLine, endLine, pcid, file));
                a.add(pcid);
                this.hmByPCID.put(pcid, id);
                ++numOfClones;
            }
            this.hmByGID.put(id, a);
            if (cloneClass == null) continue;
            this.cloneClassList.add(cloneClass);
            cloneClass = null;
        }
    }

    public ArrayList getList() {
        return this.cloneClassList;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }

    public int getMinLine() {
        return this.minLine;
    }

    public void setMinLine(int minLine) {
        this.minLine = minLine;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public int getNpcs() {
        return this.npcs;
    }

    public void setNpcs(int npcs) {
        this.npcs = npcs;
    }

    public int getNclones() {
        return this.nclones;
    }

    public void setNclones(int nclones) {
        this.nclones = nclones;
    }

    public int getNfragments() {
        return this.nfragments;
    }

    public void setNfragments(int nfragments) {
        this.nfragments = nfragments;
    }

    public int getNpairs() {
        return this.npairs;
    }

    public void setNpairs(int npairs) {
        this.npairs = npairs;
    }

    public int getNclasses() {
        return this.nclasses;
    }

    public void setNclasses(int nclasses) {
        this.nclasses = nclasses;
    }

    public long getNcompares() {
        return this.ncompares;
    }

    public void setNcompares(long ncompares) {
        this.ncompares = ncompares;
    }

    public long getCputime() {
        return this.cputime;
    }

    public void setCputime(long cputime) {
        this.cputime = cputime;
    }

    public String toString() {
        return "" + this.system + "( Threshold " + this.threshold + " Clone Classes:" + this.nclasses;
    }

    public Map<Integer, List<Integer>> getHmByGID() {
        Set<Map.Entry<Integer, List<Integer>>> set = this.hmByGID.entrySet();
        for (Map.Entry<Integer, List<Integer>> entry : set) {
        }
        return this.hmByGID;
    }

    public Map<Integer, Integer> getHmByPcid() {
        return this.hmByPCID;
    }

    public void print() {
        System.out.println("System = " + this.getSystem());
        System.out.println("Threshold = " + this.getThreshold());
        System.out.println("Granularity = " + this.getGranularity());
        System.out.println("Num of Clone classes = " + this.getNclasses());
        System.out.println("Num of Fragments = " + this.getNfragments());
        System.out.println("Num of Clones = " + this.getNclones());
        for (int i = 0; i < this.getList().size(); ++i) {
            ((CloneClass)this.getList().get(i)).print();
        }
    }
}

