/*
 * Decompiled with CFR 0.152.
 */
package gcad;

import gcad.BlockGen;
import gcad.BlockGenLiberal;
import gcad.BlockPreProcessor;
import gcad.GenealogyConstructor;
import gcad.PreProcessor;
import gcad.Result;
import gcad.ScriptGenerator;
import gcad.TypeChecker;
import gcad.Utility;
import gcad.mainClass;
import gcad.mainClassLiberal;
import gcad.settings;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;

public class CloneEvolutionUI
extends JFrame {
    String ROOT = "";
    String NiCad_path = "";
    private JMenuItem conGen;
    private JMenuItem fileSelVer;
    private JMenu jMenu1;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JPopupMenu.Separator jSeparator1;
    private JMenuItem mCurVer;
    private JMenuItem mGenealogies;
    private JMenuItem mPreProcess;
    private JMenuItem mResult;
    private JMenuItem mType;
    private JMenu menuFile;
    private JMenu menuTool;
    private JMenuItem runNiCad;
    private JFileChooser selFileChooser;
    private JMenuItem toolRun;

    public CloneEvolutionUI() {
        this.initComponents();
        try {
            BufferedReader in = new BufferedReader(new FileReader("./settings.txt"));
            this.ROOT = in.readLine();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.selFileChooser = new JFileChooser();
        this.jMenuBar1 = new JMenuBar();
        this.menuFile = new JMenu();
        this.fileSelVer = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.mCurVer = new JMenuItem();
        this.mResult = new JMenuItem();
        this.mGenealogies = new JMenuItem();
        this.menuTool = new JMenu();
        this.mPreProcess = new JMenuItem();
        this.mType = new JMenuItem();
        this.toolRun = new JMenuItem();
        this.conGen = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.runNiCad = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.setDefaultCloseOperation(3);
        this.menuFile.setText("File");
        this.fileSelVer.setText("Select Versions");
        this.fileSelVer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CloneEvolutionUI.this.fileSelVerActionPerformed(evt);
            }
        });
        this.menuFile.add(this.fileSelVer);
        this.jMenuBar1.add(this.menuFile);
        this.jMenu4.setText("View");
        this.mCurVer.setText("Current Versions");
        this.mCurVer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CloneEvolutionUI.this.mCurVerActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mCurVer);
        this.mResult.setText("Result");
        this.mResult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CloneEvolutionUI.this.mResultActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mResult);
        this.mGenealogies.setText("Genealogies");
        this.mGenealogies.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CloneEvolutionUI.this.mGenealogiesActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mGenealogies);
        this.jMenuBar1.add(this.jMenu4);
        this.menuTool.setText("Tool");
        this.mPreProcess.setText("Preprocess");
        this.mPreProcess.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CloneEvolutionUI.this.mPreProcessMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                CloneEvolutionUI.this.mPreProcessMouseExited(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                CloneEvolutionUI.this.mPreProcessMouseEntered(evt);
            }
        });
        this.mPreProcess.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CloneEvolutionUI.this.mPreProcessActionPerformed(evt);
            }
        });
        this.menuTool.add(this.mPreProcess);
        this.mType.setText("Classify Types");
        this.mType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CloneEvolutionUI.this.mTypeActionPerformed(evt);
            }
        });
        this.menuTool.add(this.mType);
        this.toolRun.setText("Map Clones");
        this.toolRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CloneEvolutionUI.this.toolRunActionPerformed(evt);
            }
        });
        this.menuTool.add(this.toolRun);
        this.conGen.setText("Construct Genealogy");
        this.conGen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CloneEvolutionUI.this.conGenActionPerformed(evt);
            }
        });
        this.menuTool.add(this.conGen);
        this.menuTool.add(this.jSeparator1);
        this.runNiCad.setText("Generate Script for NiCad");
        this.runNiCad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CloneEvolutionUI.this.runNiCadActionPerformed(evt);
            }
        });
        this.menuTool.add(this.runNiCad);
        this.jMenuItem1.setText("Settings");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CloneEvolutionUI.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.menuTool.add(this.jMenuItem1);
        this.jMenuBar1.add(this.menuTool);
        this.jMenu1.setText("Help");
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(0, 550, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(0, 446, Short.MAX_VALUE));
        this.pack();
    }

    private void fileSelVerActionPerformed(ActionEvent evt) {
        try {
            BufferedReader in = new BufferedReader(new FileReader("./settings.txt"));
            this.ROOT = in.readLine();
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.selFileChooser.setFileSelectionMode(1);
        this.selFileChooser.setMultiSelectionEnabled(true);
        this.selFileChooser.setCurrentDirectory(new File(this.ROOT + "/."));
        if (this.selFileChooser.showOpenDialog(this) == 0) {
            System.out.println("getCurrentDirectory(): " + this.selFileChooser.getCurrentDirectory());
            File[] f = this.selFileChooser.getSelectedFiles();
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(this.ROOT + "/version.txt"));
                for (int i = 0; i < f.length; ++i) {
                    out.write(f[i].getName());
                    out.newLine();
                }
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void mCurVerActionPerformed(ActionEvent evt) {
        BufferedReader in;
        String[] ver = new String[500];
        int i = 0;
        JFrame f = new JFrame("JScrollPane");
        try {
            in = new BufferedReader(new FileReader("./settings.txt"));
            this.ROOT = in.readLine();
            this.NiCad_path = in.readLine();
            in.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(f, "Settings file not found!!!");
        }
        try {
            in = new BufferedReader(new FileReader(this.ROOT + "/version.txt"));
            String str = "";
            while ((str = in.readLine()) != null) {
                System.out.println(str);
                ver[i++] = str;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(f, "Version File is not found!");
        }
        JPanel p = new JPanel(new GridLayout(0, 1));
        for (int j = 0; j < i; ++j) {
            p.add(new JLabel(ver[j]));
        }
        JScrollPane jscrollpane = new JScrollPane(p);
        f.getContentPane().add(jscrollpane);
        if (i * 40 > 300) {
            f.setSize(300, 300);
        } else {
            f.setSize(300, i * 40);
        }
        f.setLocationRelativeTo(this.getRootPane());
        f.setVisible(true);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        settings sett = new settings();
        sett.setLocationRelativeTo(this.getRootPane());
        sett.setVisible(true);
    }

    private void runNiCadActionPerformed(ActionEvent evt) {
        String ROOT = "";
        String CDTPath = "";
        String gran = "";
        String rename = "";
        String mode = "";
        String UPIT = "";
        String lang = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader("./settings.txt"));
            ROOT = in.readLine();
            in.readLine();
            CDTPath = in.readLine();
            lang = in.readLine();
            if (lang.equals("Java")) {
                lang = "java";
            } else if (lang.equals("C Renaming")) {
                lang = "c";
            } else if (lang.equals("C#")) {
                lang = "cs";
            } else {
                JOptionPane.showMessageDialog(this, "Language not supported!", "Alert", 0);
            }
            gran = in.readLine();
            if (gran.equals("Function")) {
                gran = "functions";
            } else if (gran.equals("Block")) {
                gran = "blocks";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Granularity!", "Alert", 0);
            }
            rename = in.readLine();
            if (rename.equals("Consistent Renaming")) {
                rename = "consistent";
            } else if (rename.equals("Blind Renaming")) {
                rename = "blind";
            } else if (rename.equals("No Renaming")) {
                rename = "";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Renaming Option", "Alert", 0);
            }
            UPIT = in.readLine();
            mode = in.readLine();
            in.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Settings file not found!!!", "Alert", 0);
        }
        try {
            ScriptGenerator sg = new ScriptGenerator();
            ScriptGenerator.generate(ROOT, CDTPath, lang, gran, rename);
        }
        catch (Exception E) {
            JOptionPane.showMessageDialog(this, "Could not create the script!", "Alert", 0);
        }
        JOptionPane.showMessageDialog(this, "Script was created successfully!!!");
    }

    private void toolRunActionPerformed(ActionEvent evt) {
        Object bg;
        Object mc;
        String SRC_PATH = "";
        String gran = "";
        String rename = "";
        String mode = "";
        String UPIT = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader("./settings.txt"));
            in.readLine();
            in.readLine();
            in.readLine();
            in.readLine();
            gran = in.readLine();
            rename = in.readLine();
            if (rename.equals("Consistent Renaming")) {
                rename = "consistent";
            } else if (rename.equals("Blind Renaming")) {
                rename = "blind";
            } else if (rename.equals("No Renaming")) {
                rename = "";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Renaming Option", "Alert", 0);
            }
            UPIT = in.readLine();
            mode = in.readLine();
            in.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Settings file not found!!!");
        }
        if (gran.equals("Function") && mode.equals("Strict")) {
            mc = new mainClass();
            try {
                JFrame f = new JFrame();
                ((mainClass)mc).map(f, rename);
            }
            catch (Exception e) {}
        } else if (gran.equals("Block") && mode.equals("Strict")) {
            bg = new BlockGen();
            try {
                JFrame f = new JFrame();
                ((BlockGen)bg).mapBlock(f, rename);
            }
            catch (Exception e) {}
        } else if (gran.equals("Function") && mode.equals("Liberal")) {
            mc = new mainClassLiberal();
            try {
                JFrame f = new JFrame();
                ((mainClassLiberal)mc).map(f, rename);
            }
            catch (Exception e) {}
        } else if (gran.equals("Block") && mode.equals("Liberal")) {
            bg = new BlockGenLiberal();
            try {
                JFrame f = new JFrame();
                ((BlockGenLiberal)bg).mapBlock(f, rename);
            }
            catch (Exception e) {}
        } else {
            JOptionPane.showMessageDialog(this, "Invalid Granularity or Mode", "Alert", 0);
        }
    }

    private void mPreProcessActionPerformed(ActionEvent evt) {
        PreProcessor pp;
        String SRC_PATH = "";
        String gran = "";
        String rename = "";
        String mode = "";
        String UPIT = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader("./settings.txt"));
            in.readLine();
            in.readLine();
            in.readLine();
            in.readLine();
            gran = in.readLine();
            rename = in.readLine();
            if (rename.equals("Consistent Renaming")) {
                rename = "consistent";
            } else if (rename.equals("Blind Renaming")) {
                rename = "blind";
            } else if (rename.equals("No Renaming")) {
                rename = "";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Renaming Option", "Alert", 0);
            }
            UPIT = in.readLine();
            mode = in.readLine();
            in.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Settings file not found!!!");
        }
        if (gran.equals("Function")) {
            pp = new PreProcessor();
            try {
                JFrame f = new JFrame();
                if (pp.preProcessFunction(f, rename)) {
                    JOptionPane.showMessageDialog(this, "Preprocessing of function clones are successful!");
                }
            }
            catch (Exception e) {}
        } else if (gran.equals("Block")) {
            pp = new PreProcessor();
            try {
                JFrame f = new JFrame();
                pp.preProcessFunction(f, rename);
            }
            catch (Exception e) {
                // empty catch block
            }
            BlockPreProcessor bpp = new BlockPreProcessor();
            try {
                JFrame f = new JFrame();
                if (bpp.preProcessBlock(f, rename)) {
                    JOptionPane.showMessageDialog(this, "Preprocessing of block clones are successful!");
                }
            }
            catch (Exception e) {}
        } else {
            JOptionPane.showMessageDialog(this, "Invalid Granularity", "Alert", 0);
        }
    }

    private void mTypeActionPerformed(ActionEvent evt) {
        String ROOT = "";
        String CDTPath = "";
        String gran = "";
        String rename = "";
        String mode = "";
        String UPIT = "";
        String lang = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader("./settings.txt"));
            ROOT = in.readLine();
            in.readLine();
            CDTPath = in.readLine();
            in.readLine();
            gran = in.readLine();
            if (gran.equals("Function")) {
                gran = "functions";
            } else if (gran.equals("Block")) {
                gran = "blocks";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Granularity!", "Alert", 0);
            }
            rename = in.readLine();
            if (rename.equals("Consistent Renaming")) {
                rename = "consistent";
            } else if (rename.equals("Blind Renaming")) {
                rename = "blind";
            } else if (rename.equals("No Renaming")) {
                rename = "";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Renaming Option", "Alert", 0);
            }
            UPIT = in.readLine();
            mode = in.readLine();
            in.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Settings file not found!!!");
        }
        try {
            TypeChecker tc = new TypeChecker();
            if (TypeChecker.classifyType(ROOT, rename, gran)) {
                JOptionPane.showMessageDialog(this, "Clone classes are categorized by Types.");
            } else {
                JOptionPane.showMessageDialog(this, "Categorization unsuccessful!", "Alert", 0);
            }
        }
        catch (Exception E) {
            // empty catch block
        }
    }

    private void conGenActionPerformed(ActionEvent evt) {
        String ROOT = "";
        String CDTPath = "";
        String gran = "";
        String rename = "";
        String mode = "";
        String UPIT = "";
        String lang = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader("./settings.txt"));
            ROOT = in.readLine();
            in.readLine();
            CDTPath = in.readLine();
            in.readLine();
            gran = in.readLine();
            if (gran.equals("Function")) {
                gran = "function";
            } else if (gran.equals("Block")) {
                gran = "block";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Granularity!", "Alert", 0);
            }
            rename = in.readLine();
            if (rename.equals("Consistent Renaming")) {
                rename = "consistent";
            } else if (rename.equals("Blind Renaming")) {
                rename = "blind";
            } else if (rename.equals("No Renaming")) {
                rename = "";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Renaming Option", "Alert", 0);
            }
            UPIT = in.readLine();
            mode = in.readLine();
            in.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Settings file not found!!!");
        }
        try {
            GenealogyConstructor gen = new GenealogyConstructor();
            if (GenealogyConstructor.constructGenealogy(ROOT, rename, gran, mode.toLowerCase())) {
                JOptionPane.showMessageDialog(this, "Genealogies have been constructed successfully!\nPlease see the genealogies in " + ROOT + "/" + "Genealogies_" + mode.toLowerCase() + "_" + rename + "_" + gran + ".txt and\nSummary in " + ROOT + "/" + "Report_summary_" + mode.toLowerCase() + "_" + rename + "_" + gran + ".txt");
            } else {
                JOptionPane.showMessageDialog(this, "Categorization unsuccessful!", "Alert", 0);
            }
        }
        catch (Exception E) {
            // empty catch block
        }
    }

    private void mPreProcessMouseEntered(MouseEvent evt) {
    }

    private void mPreProcessMouseClicked(MouseEvent evt) {
    }

    private void mPreProcessMouseExited(MouseEvent evt) {
    }

    private void mResultActionPerformed(ActionEvent evt) {
        String ROOT = "";
        String CDTPath = "";
        String gran = "";
        String rename = "";
        String mode = "";
        String UPIT = "";
        String lang = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader("./settings.txt"));
            ROOT = in.readLine();
            in.readLine();
            CDTPath = in.readLine();
            in.readLine();
            gran = in.readLine();
            if (gran.equals("Function")) {
                gran = "function";
            } else if (gran.equals("Block")) {
                gran = "block";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Granularity!", "Alert", 0);
            }
            rename = in.readLine();
            if (rename.equals("Consistent Renaming")) {
                rename = "consistent";
            } else if (rename.equals("Blind Renaming")) {
                rename = "blind";
            } else if (rename.equals("No Renaming")) {
                rename = "";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Renaming Option", "Alert", 0);
            }
            UPIT = in.readLine();
            mode = in.readLine();
            in.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Settings file not found!!!");
        }
        Utility myUtil = new Utility();
        String str = "";
        String filePath = "";
        try {
            filePath = ROOT + "/" + "Result_summary_" + mode.toLowerCase() + "_" + rename + "_" + gran + ".txt";
            str = myUtil.readFileSingleLine(filePath);
            Result res = new Result();
            res.setContent(str, filePath);
            res.setVisible(true);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int w = res.getSize().width;
            int h = res.getSize().height;
            int x = (dim.width - w) / 2;
            int y = (dim.height - h) / 2;
            res.setLocation(x, y);
            res.setDefaultCloseOperation(0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "You have no result for this settings. \nPlease check your settings from Tools->Settings", "Alert", 0);
        }
    }

    private void mGenealogiesActionPerformed(ActionEvent evt) {
        String ROOT = "";
        String CDTPath = "";
        String gran = "";
        String rename = "";
        String mode = "";
        String UPIT = "";
        String lang = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader("./settings.txt"));
            ROOT = in.readLine();
            in.readLine();
            CDTPath = in.readLine();
            in.readLine();
            gran = in.readLine();
            if (gran.equals("Function")) {
                gran = "function";
            } else if (gran.equals("Block")) {
                gran = "block";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Granularity!", "Alert", 0);
            }
            rename = in.readLine();
            if (rename.equals("Consistent Renaming")) {
                rename = "consistent";
            } else if (rename.equals("Blind Renaming")) {
                rename = "blind";
            } else if (rename.equals("No Renaming")) {
                rename = "";
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Renaming Option", "Alert", 0);
            }
            UPIT = in.readLine();
            mode = in.readLine();
            in.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Settings file not found!!!");
        }
        String filePath = "";
        try {
            filePath = ROOT + "/" + "Result_summary_" + mode.toLowerCase() + "_" + rename + "_" + gran + ".txt";
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            JOptionPane.showMessageDialog(this, "Please open " + ROOT + "/" + "Genealogies_" + mode.toLowerCase() + "_" + rename + "_" + gran + ".txt\nto see the details of each genealogy.");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "You have no result for this settings. \nPlease check your settings from Tools->Settings", "Alert", 0);
        }
    }

    void writeProcessOutput(Process process) throws Exception {
        String line;
        InputStreamReader tempReader = new InputStreamReader(new BufferedInputStream(process.getInputStream()));
        BufferedReader reader = new BufferedReader(tempReader);
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CloneEvolutionUI().setVisible(true);
            }
        });
    }
}

