// $Id: PropPanelParameter.java 14846 2008-05-31 12:17:02Z bobtarling $
// Copyright (c) 1996-2007 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies.  This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason.  IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,g
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.uml.ui.foundation.core;

import java.util.List;

import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.ui.targetmanager.TargetManager;
import org.argouml.uml.ui.ActionNavigateContainerElement;
import org.argouml.uml.ui.ActionNavigateUpNextDown;
import org.argouml.uml.ui.ActionNavigateUpPreviousDown;
import org.argouml.uml.ui.UMLComboBox2;
import org.argouml.uml.ui.UMLExpressionBodyField;
import org.argouml.uml.ui.UMLExpressionLanguageField;
import org.argouml.uml.ui.UMLExpressionModel2;
import org.argouml.uml.ui.UMLUserInterfaceContainer;
import org.argouml.uml.ui.foundation.extension_mechanisms.ActionNewStereotype;

/**
 * The property panel for parameters.
 */
public class PropPanelParameter extends PropPanelModelElement {

    /**
     * The serial version.
     */
    private static final long serialVersionUID = -1207518946939283220L;

    private JPanel behFeatureScroll;

    private static UMLParameterBehavioralFeatListModel behFeatureModel;

    /**
     * Construct a property panel for UML Parameter elements.
     */
    public PropPanelParameter() {
        super("label.parameter", lookupIcon("Parameter"));

        addField(Translator.localize("label.name"), getNameTextField());
        addField(Translator.localize("label.owner"),
                getBehavioralFeatureScroll());

        addSeparator();

        addField(Translator.localize("label.type"),
                new UMLComboBox2(new UMLParameterTypeComboBoxModel(),
                        ActionSetParameterType.getInstance()));

        UMLExpressionModel2 defaultModel = new UMLDefaultValueExpressionModel(
                this, "defaultValue");
        JPanel defaultPanel = createBorderPanel(Translator
                .localize("label.parameter.default-value"));
        defaultPanel.add(new JScrollPane(new UMLExpressionBodyField(
                defaultModel, true)));
        defaultPanel.add(new UMLExpressionLanguageField(defaultModel,
                false));
        add(defaultPanel);

        add(new UMLParameterDirectionKindRadioButtonPanel(
                Translator.localize("label.parameter.kind"), true));

        addAction(new ActionNavigateContainerElement());

        // Up & Down are only enabled if the Parameter list is ordered
        addAction(new ActionNavigateUpPreviousDown() {
            public List getFamily(Object parent) {
                return Model.getFacade().getParametersList(parent);
            }

            public Object getParent(Object child) {
                return Model.getFacade().getModelElementContainer(child);
            }
            
            public boolean isEnabled() {
                return (Model.getFacade().isABehavioralFeature(getTarget()) 
                        || Model.getFacade().isAEvent(getTarget())
                        ) && super.isEnabled();
            }
        });
        addAction(new ActionNavigateUpNextDown() {
            public List getFamily(Object parent) {
                return Model.getFacade().getParametersList(parent);
            }

            public Object getParent(Object child) {
                return Model.getFacade().getModelElementContainer(child);
            }
            
            public boolean isEnabled() {
                return (Model.getFacade().isABehavioralFeature(getTarget()) 
                        || Model.getFacade().isAEvent(getTarget())
                        ) && super.isEnabled();
            }
        });
        addAction(new ActionNewParameter());
        addAction(new ActionAddDataType());
        addAction(new ActionAddEnumeration());
        addAction(new ActionNewStereotype());
        addAction(getDeleteAction());
    }

    /**
     * Returns the behavioral Feature Scroll.
     *
     * @return JPanel
     */
    public JPanel getBehavioralFeatureScroll() {
        if (behFeatureScroll == null) {
            if (behFeatureModel == null) {
                behFeatureModel = new UMLParameterBehavioralFeatListModel();
            }
            behFeatureScroll = getSingleRowScroll(behFeatureModel);
        }
        return behFeatureScroll;
    }

}

class UMLDefaultValueExpressionModel extends UMLExpressionModel2 {

    /**
     * The constructor.
     *
     * @param container the container of UML user interface components
     * @param propertyName the name of the property
     */
    public UMLDefaultValueExpressionModel(UMLUserInterfaceContainer container,
            String propertyName) {
        super(container, propertyName);
    }

    /*
     * @see org.argouml.uml.ui.UMLExpressionModel2#getExpression()
     */
    public Object getExpression() {
        Object target = TargetManager.getInstance().getTarget();
        if (target == null) {
            return null;
        }
        return Model.getFacade().getDefaultValue(target);
    }

    /*
     * @see org.argouml.uml.ui.UMLExpressionModel2#setExpression(java.lang.Object)
     */
    public void setExpression(Object expression) {
        Object target = TargetManager.getInstance().getTarget();

        if (target == null) {
            throw new IllegalStateException(
                    "There is no target for " + getContainer());
        }
        Model.getCoreHelper().setDefaultValue(target, expression);
    }

    /*
     * @see org.argouml.uml.ui.UMLExpressionModel2#newExpression()
     */
    public Object newExpression() {
        return Model.getDataTypesFactory().createExpression("", "");
    }

}