// $Id: UmlObjectPropPanelFactory.java 15056 2008-06-23 17:46:24Z mvw $
// Copyright (c) 2008 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies. This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason. IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.uml.ui;

import org.argouml.model.Model;
import org.argouml.uml.ui.foundation.core.PropPanelElementResidence;
import org.argouml.uml.ui.model_management.PropPanelElementImport;

/**
 * This factory creates the right PropPanel
 * for a given UML Object that is not an "element", 
 * such as Expression and Multiplicity. <p>
 * 
 * The complete list of UML objects that are not Element:
 * ElementImport,
 * ElementResidence
 * Expression (9 types)
 * Multiplicity
 * MultiplicityRange
 * TemplateArgument
 * TemplateParameter
 *
 * @author Michiel
 */
class UmlObjectPropPanelFactory implements PropPanelFactory {

    public PropPanel createPropPanel(Object object) {
        if (Model.getFacade().isAExpression(object)) {
            return getExpressionPropPanel(object);
        }
        if (Model.getFacade().isAMultiplicity(object)) {
            return getMultiplicityPropPanel(object);
        }
        if (Model.getFacade().isAElementImport(object)) {
            return new PropPanelElementImport();
        }
        if (Model.getFacade().isAElementResidence(object)) {
            return new PropPanelElementResidence();
        }
        return null;
    }

    private PropPanel getExpressionPropPanel(Object object) {
        return null;
    }

    private PropPanel getMultiplicityPropPanel(Object object) {
        return null;
    }
}
