// $Id: XmiReference.java 14013 2007-12-28 05:04:33Z tfmorris $
// Copyright (c) 2005-2006 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies.  This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason.  IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.model.mdr;

/**
 * Reference to an XMI element.  Value object containing a tuple
 * of the system ID (URI) and xmi.id within the given content.
 * 
 * @author Tom Morris
 */
class XmiReference {
    private final String systemId;

    private final String xmiId;

    /**
     * Create a XMI id reference object.
     * 
     * @param system
     *            system ID
     * @param xmi
     *            XMI id
     */
    XmiReference(String system, String xmi) {
        systemId = system;
        xmiId = xmi;
    }

    /**
     * Get the system ID (typically a URI pointing to a file) for the given XMI
     * reference.
     * 
     * @return the systemID value (string containing filename)
     */
    String getSystemId() {
        return systemId;
    }

    /**
     * Get the xmi.id for the reference. This must be unique within the given
     * XMI file (system ID), but is not guaranteed to be globally unique.
     * 
     * @return the xmi.id value
     */
    String getXmiId() {
        return xmiId;
    }
}