// $Id$
/*
 [The "BSD licence"]
 Copyright (c) 2007-2008 Terence Parr
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. The name of the author may not be used to endorse or promote products
    derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
// Copyright note for the modifications/additions for the ArgoUML project:
//
// Copyright (c) 2003-2008 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies.  This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason.  IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

/**
 * This is the Java 1.5 grammar for reverse engineering Java source code
 * to a UML model.
 * 
 * <p>It is generated by the ANTLR V.3 parser generator (www.antlr.org).
 *    Antlr uses the Java.g grammar file to generate the JavaParser.java
 *    parser.
 * 
 * <p><strong>DO NOT MODIFY JavaParser.java</strong>
 * 
 * <p>If you need to modify how Argo parses Java files then:
 * <ol>
 *     <li>modify <strong>Java.g</strong>. See the antlr website
 *         for examples of how to modify a antlr grammar file</li>
 *     <li>save Java.g and run argo's build script with the 
 *         "<strong>generateparser</strong>" target.</li>
 *     <li>build argo again.</li>
 * </ol>
 * 
 * <pre>
 * --------- original notes: -------------------------------------------
 *
 *  This is a very close representation of the spec; the changes
 *  are comestic (remove left recursion) and also fixes (the spec
 *  isn't exactly perfect).  I have run this on the 1.4.2 source
 *  and some nasty looking enums from 1.5, but have not really
 *  tested for 1.5 compatibility.
 *
 *  I built this with: java -Xmx100M org.antlr.Tool java.g 
 *  and got two errors that are ok (for now):
 *  java.g:691:9: Decision can match input such as
 *    "'0'..'9'{'E', 'e'}{'+', '-'}'0'..'9'{'D', 'F', 'd', 'f'}"
 *    using multiple alternatives: 3, 4
 *  As a result, alternative(s) 4 were disabled for that input
 *  java.g:734:35: Decision can match input such as "{'$', 'A'..'Z',
 *    '_', 'a'..'z', '\u00C0'..'\u00D6', '\u00D8'..'\u00F6',
 *    '\u00F8'..'\u1FFF', '\u3040'..'\u318F', '\u3300'..'\u337F',
 *    '\u3400'..'\u3D2D', '\u4E00'..'\u9FFF', '\uF900'..'\uFAFF'}"
 *    using multiple alternatives: 1, 2
 *  As a result, alternative(s) 2 were disabled for that input
 *
 *  You can turn enum on/off as a keyword :)
 *
 *  Version 1.0 -- initial release July 5, 2006 (requires 3.0b2 or higher)
 *
 *  Primary author: Terence Parr, July 2006
 *
 *  Version 1.0.1 -- corrections by Koen Vanderkimpen & Marko van Dooren,
 *      October 25, 2006;
 *      fixed normalInterfaceDeclaration: now uses typeParameters instead
 *          of typeParameter (according to JLS, 3rd edition)
 *      fixed castExpression: no longer allows expression next to type
 *          (according to semantics in JLS, in contrast with syntax in JLS)
 *
 *  Version 1.0.2 -- Terence Parr, Nov 27, 2006
 *      java spec I built this from had some bizarre for-loop control.
 *          Looked weird and so I looked elsewhere...Yep, it's messed up.
 *          simplified.
 *
 *  Version 1.0.3 -- Chris Hogue, Feb 26, 2007
 *      Factored out an annotationName rule and used it in the annotation rule.
 *          Not sure why, but typeName wasn't recognizing references to inner
 *          annotations (e.g. @InterfaceName.InnerAnnotation())
 *      Factored out the elementValue section of an annotation reference.  Created 
 *          elementValuePair and elementValuePairs rules, then used them in the 
 *          annotation rule.  Allows it to recognize annotation references with 
 *          multiple, comma separated attributes.
 *      Updated elementValueArrayInitializer so that it allows multiple elements.
 *          (It was only allowing 0 or 1 element).
 *      Updated localVariableDeclaration to allow annotations.  Interestingly the JLS
 *          doesn't appear to indicate this is legal, but it does work as of at least
 *          JDK 1.5.0_06.
 *      Moved the Identifier portion of annotationTypeElementRest to annotationMethodRest.
 *          Because annotationConstantRest already references variableDeclarator which 
 *          has the Identifier portion in it, the parser would fail on constants in 
 *          annotation definitions because it expected two identifiers.  
 *      Added optional trailing ';' to the alternatives in annotationTypeElementRest.
 *          Wouldn't handle an inner interface that has a trailing ';'.
 *      Swapped the expression and type rule reference order in castExpression to 
 *          make it check for genericized casts first.  It was failing to recognize a
 *          statement like  "Class<Byte> TYPE = (Class<Byte>)...;" because it was seeing
 *          'Class<Byte' in the cast expression as a less than expression, then failing 
 *          on the '>'.
 *      Changed createdName to use typeArguments instead of nonWildcardTypeArguments.
 *          Again, JLS doesn't seem to allow this, but java.lang.Class has an example of
 *          of this construct.
 *      Changed the 'this' alternative in primary to allow 'identifierSuffix' rather than
 *          just 'arguments'.  The case it couldn't handle was a call to an explicit
 *          generic method invocation (e.g. this.<E>doSomething()).  Using identifierSuffix
 *          may be overly aggressive--perhaps should create a more constrained thisSuffix rule?
 *      
 *  Version 1.0.4 -- Hiroaki Nakamura, May 3, 2007
 *
 *  Fixed formalParameterDecls, localVariableDeclaration, forInit,
 *  and forVarControl to use variableModifier* not 'final'? (annotation)?
 *
 *  Version 1.0.5 -- Terence, June 21, 2007
 *  --a[i].foo didn't work. Fixed unaryExpression
 *
 *  Version 1.0.6 -- John Ridgway, March 17, 2008
 *      Made "assert" a switchable keyword like "enum".
 *      Fixed compilationUnit to disallow "annotation importDeclaration ...".
 *      Changed "Identifier ('.' Identifier)*" to "qualifiedName" in more 
 *          places.
 *      Changed modifier* and/or variableModifier* to classOrInterfaceModifiers,
 *          modifiers or variableModifiers, as appropriate.
 *      Renamed "bound" to "typeBound" to better match language in the JLS.
 *      Added "memberDeclaration" which rewrites to methodDeclaration or 
 *      fieldDeclaration and pulled type into memberDeclaration.  So we parse 
 *          type and then move on to decide whether we're dealing with a field
 *          or a method.
 *      Modified "constructorDeclaration" to use "constructorBody" instead of
 *          "methodBody".  constructorBody starts with explicitConstructorInvocation,
 *          then goes on to blockStatement*.  Pulling explicitConstructorInvocation
 *          out of expressions allowed me to simplify "primary".
 *      Changed variableDeclarator to simplify it.
 *      Changed type to use classOrInterfaceType, thus simplifying it; of course
 *          I then had to add classOrInterfaceType, but it is used in several 
 *          places.
 *      Fixed annotations, old version allowed "@X(y,z)", which is illegal.
 *      Added optional comma to end of "elementValueArrayInitializer"; as per JLS.
 *      Changed annotationTypeElementRest to use normalClassDeclaration and 
 *          normalInterfaceDeclaration rather than classDeclaration and 
 *          interfaceDeclaration, thus getting rid of a couple of grammar ambiguities.
 *      Split localVariableDeclaration into localVariableDeclarationStatement
 *          (includes the terminating semi-colon) and localVariableDeclaration.  
 *          This allowed me to use localVariableDeclaration in "forInit" clauses,
 *           simplifying them.
 *      Changed switchBlockStatementGroup to use multiple labels.  This adds an
 *          ambiguity, but if one uses appropriately greedy parsing it yields the
 *           parse that is closest to the meaning of the switch statement.
 *      Renamed "forVarControl" to "enhancedForControl" -- JLS language.
 *      Added semantic predicates to test for shift operations rather than other
 *          things.  Thus, for instance, the string "< <" will never be treated
 *          as a left-shift operator.
 *      In "creator" we rule out "nonWildcardTypeArguments" on arrayCreation, 
 *          which are illegal.
 *      Moved "nonWildcardTypeArguments into innerCreator.
 *      Removed 'super' superSuffix from explicitGenericInvocation, since that
 *          is only used in explicitConstructorInvocation at the beginning of a
 *           constructorBody.  (This is part of the simplification of expressions
 *           mentioned earlier.)
 *      Simplified primary (got rid of those things that are only used in
 *          explicitConstructorInvocation).
 *      Lexer -- removed "Exponent?" from FloatingPointLiteral choice 4, since it
 *          led to an ambiguity.
 *
 *      This grammar successfully parses every .java file in the JDK 1.5 source 
 *          tree (excluding those whose file names include '-', which are not
 *          valid Java compilation units).
 *
 *  Known remaining problems:
 *      "Letter" and "JavaIDDigit" are wrong.  The actual specification of
 *      "Letter" should be "a character for which the method
 *      Character.isJavaIdentifierStart(int) returns true."  A "Java 
 *      letter-or-digit is a character for which the method 
 *      Character.isJavaIdentifierPart(int) returns true."
 * 
 * --------- further ArgoUML notes: -----------------------------------
 *
 * Modified by Thomas Neustupny (April 18, 2008)
 *    o Added a lot of stuff for the UML Modeler from the former Antlr 2 grammar
 *    o Not passing typeArguments and typeParameters to the Modeler (don't how they map to UML)
 *    o from Tom Morris, who did this in the former Antlr 2 grammar:
 *      Added support to pass variableLengthParameterDeclaration to Modeler
 *    o from Tom Morris, who did this in the former Antlr 2 grammar:
 *      Added stubs for typeParameters, typeArguments, annotations and
 *      annotationDefinitions and so we can warn when they're skipped.
 *
 * This grammar is in the PUBLIC DOMAIN
 * </pre>
 */
grammar Java;
options {k=2; backtrack=true; memoize=true;}

@header {
package org.argouml.language.java.reveng;
}

@members {
    /**
     * Counts the number of LT seen in the typeArguments production.
     * It is used in semantic predicates to ensure we have seen
     * enough closing '>' characters; which actually may have been
     * either GT, SR or BSR tokens.
     */
    private int ltCounter = 0;

    // Constants for access modifiers according to the JVM specs chapter 4
    public static final short ACC_PUBLIC    = 0x0001;
    public static final short ACC_PRIVATE   = 0x0002;
    public static final short ACC_PROTECTED = 0x0004;
    public static final short ACC_STATIC    = 0x0008;
    public static final short ACC_FINAL     = 0x0010;
    public static final short ACC_SUPER     = 0x0020;
    public static final short ACC_VOLATILE  = 0x0040;
    public static final short ACC_TRANSIENT = 0x0080;
    public static final short ACC_NATIVE    = 0x0100;
    public static final short ACC_INTERFACE = 0x0200;
    public static final short ACC_ABSTRACT  = 0x0400;                     

    /** Parser mode for the first pass of the import from sources */
    public static final int MODE_IMPORT_PASS1 = 1;
    /** Parser mode for the second pass of the import from sources */
    public static final int MODE_IMPORT_PASS2 = 2;
    /** Parser mode for the source code generation in update mode */
    public static final int MODE_GENERATION_UPDATE = 4;
    /** Parser mode for the reverse engineering of a sequence diagram */
    public static final int MODE_REVENG_SEQUENCE = 8;

    /** The parser mode, that controls which semantic expressions will be active */
    private int parserMode = 0;

    /** The name of the variable to which a created object (new...) is assigned to */
    private String createdObjectVarName = null;
   
    /** Import details level */
    private int level = 2;

    /** Set the parser mode, to control which semantic expressions will be active */
    public void setParserMode(int mode) {
        parserMode = mode;
    }
    
    // This one is not(!) in the JVM specs, but required
    public static final short ACC_SYNCHRONIZED  = 0x0800;

    /**
     * To get direct access to the lexer (for the javadoc
     * comments), we store a reference to it.
     */
    private JavaLexer _lexer = null;

    /**
     * A buffer to hold the last parsed javadoc comment.
     */
    String _javadocComment = null;

    /**
     * Return (and consume) the last available Javadoc Comment.
     *
     * @return The last parsed javadoc comment.
     */
    protected String getJavadocComment() {
        String result = _javadocComment;
        _javadocComment = null;  // Since we consume the comment, the buffer is reset.
        return result;
    }

    /**
     * Updates the last parsed javadoc comment.
     */
    private void updateJavadocComment() {
        Token t = null;
        int i = input.index();
        if (i == 0) {
            return;
        }
        do {
            t = (Token)input.get(--i);
        } while (i >= 0 && t.getType()== _lexer.WS);
        if (t.getType() == _lexer.JAVADOC) {
            _javadocComment = t.getText();
        }
    }
    
    private Modeller _modeller;

    public Modeller getModeller() {
        return _modeller;
    }

    public void setModeller(Modeller modeller) {
        _modeller = modeller;
        Object lvl = modeller.getAttribute("level");
        if (lvl != null) {
          level = ((Integer)lvl).intValue();
        }
    }
    
        // A reference to the last added Operation (here: method)
        private Object _currentMethod = null;

    /**
     * get reference to the last added Operation (here: method)
     */
    Object getMethod() {
        return _currentMethod;
    }

    /**
     * set reference to the last added Operation (here: method)
     */
    void setMethod(Object method) {
        _currentMethod = method;
    }

    // A method body
    private String _methodBody = null;

    /**
     * get last method body
     */
    String getBody() {
        return _methodBody;
    }

    /**
     * set last method body
     */
    void setBody(String body) {
        _methodBody = body;
    }

    // A flag to indicate if we are inside a compoundStatement
    private boolean      _inCompoundStatement  = false;    

    /**
     * set if we are inside a compoundStatement
     */
    void setIsInCompoundStatement(boolean flag) {
        _inCompoundStatement = flag;
    }

    /**
     * check if we are inside a compoundStatement
     */
    boolean isInCompoundStatement() {
        return _inCompoundStatement;
    }

    /**
     * Add a call that appears after a dot. This is needed for the RE of
     * sequence diagrams and is currently not used. Should be called in the
     * identifierSuffix rule.
     */
    private void addDotCall(String id, String thisOrSuper, boolean parenths) {
        StringBuffer sb = new StringBuffer();
        List<String> calls = getModeller().getMethodCalls();
        String prev = calls.get(calls.size() - 1);
        if (thisOrSuper != null) {
            sb.append(thisOrSuper);
        } else if (prev != null) {
            if (parenths) {
                sb.append('(');
            }
            sb.append(prev).append("()");
            if (parenths) {
                sb.append(')');
            }
            sb.append('.');
        }
        sb.append(id);
        getModeller().addCall(sb.toString());
    }
}

@lexer::header {
package org.argouml.language.java.reveng;
}

@lexer::members {
    protected boolean enumIsKeyword = true;
    protected boolean assertIsKeyword = true;
}


// Compilation Unit: In Java, this is a single file. This is the start
// rule for this parser in most modes
/* The annotations are separated out to make parsing faster, but must be associated with
   a packageDeclaration or a typeDeclaration (and not an empty one). */
compilationUnit[Modeller modeller, JavaLexer lexer]
    @init{
        setModeller(modeller);
        _lexer = lexer;
        if (state.backtracking == 0) {
            getModeller().addComponent();
        }
    }
    :   ('@')=> annotations
        (   packageDeclaration importDeclaration* typeDeclaration*
        |   classOrInterfaceDeclaration typeDeclaration*
       )
    |   (packageDeclaration)? importDeclaration* typeDeclaration*
    ;

// Package statement: optional annotations followed by "package" then the package identifier.
packageDeclaration
    :   'package' packageName=qualifiedName ';'
        {
            getModeller().addPackage($packageName.text);
        }         
    ;

// Import statement: import followed by a package or class name
importDeclaration
    @init{
        StringBuffer sb = new StringBuffer(80);
    }
    :   'import' 'static'?
        importName=qualifiedName { sb.append($importName.text); }
        ('.' '*' { sb.append(".*"); } )? ';'
        {
            getModeller().addImport(sb.toString(),
                (parserMode == MODE_IMPORT_PASS2));
        }
    ;

// A type declaration is either a class, interface, enum or annotation with possible additional semis.
typeDeclaration
    :   classOrInterfaceDeclaration
    |   ';'
    ;

classOrInterfaceDeclaration
    :   m=classOrInterfaceModifiers
        (   classDeclaration[getJavadocComment(), m]
        |   interfaceDeclaration[getJavadocComment(), m]
        )
    ;
    
classOrInterfaceModifiers returns [short m = 0]
    :   {
            updateJavadocComment();
        }
        (   sub_m=classOrInterfaceModifier
            {
                m |= sub_m;
            }
        )*
    ;

classOrInterfaceModifier returns [short m = 0]
    :   annotation
    |   'public'     { m = ACC_PUBLIC; }
    |   'protected'  { m = ACC_PROTECTED; }
    |   'private'    { m = ACC_PRIVATE; }
    |   'abstract'   { m = ACC_ABSTRACT; }
    |   'static'     { m = ACC_STATIC; }
    |   'final'      { m = ACC_FINAL; } // class only -- does not apply to interfaces
    |   'strictfp'
    ;

modifiers returns [short m = 0]
    :   {
            updateJavadocComment();
        }
        (   sub_m=modifier
            {
                m |= sub_m;
            }
        )*
    ;

// Declaration of a Java class
classDeclaration[String javadoc, short modifiers]
    :   normalClassDeclaration[javadoc, modifiers]
    |   enumDeclaration[javadoc, modifiers]
    ;
    
normalClassDeclaration[String javadoc, short modifiers]
    @init{
        String superClassName = null;
        List<String> ic = new ArrayList<String>();
        List<String> tparam = new ArrayList<String>();
    }
    :   'class' className=Identifier
        (tp=typeParameters { tparam = tp; } )?
        ('extends' t=type { superClassName = t; } )?
        ('implements' tl=typeList { ic = tl; } )?
        {
            if (!isInCompoundStatement()) {
                getModeller().addClass($className.text, modifiers, tparam,
                    superClassName, ic, javadoc,
                    (parserMode == MODE_IMPORT_PASS2));
            }
        }
        // now parse the body of the class
        classBody
        {
            if (!isInCompoundStatement()) {
                getModeller().popClassifier();
            }
        }
    ;

typeParameters returns [List<String> names = new ArrayList<String>()]
    @init{
        int currentLtLevel = ltCounter;
        getModeller().addTypeParameters();
    }
    :
        '<'                  { ltCounter++; }
        n=typeParameter      { names.add(n); }
        (',' n=typeParameter { names.add(n); }
        )*
        '>'                  { ltCounter--; }
        // make sure we have gobbled up enough '>' characters
        // if we are at the "top level" of nested typeArgument productions
        { currentLtLevel != 0 || ltCounter == currentLtLevel }?
    ;

typeParameter returns [String type = null]
    @init{
        StringBuffer sb = new StringBuffer();
    }
    :   t=Identifier              { sb.append($t.text); }
        ('extends' name=typeBound { sb.append(" extends ").append(name); }
        )?
        {
            type = sb.toString();
        }
    ;
        
typeBound returns [String type = null]
    @init{
        StringBuffer sb = new StringBuffer();
    }
    :   name=type      { sb.append(name); }
        ('&' name=type { sb.append("&").append(name); }
        )*
        {
            type = sb.toString();
        }
    ;

// Declaration of a Java enum
enumDeclaration[String javadoc, short modifiers]
    @init{
        List<String> ic = new ArrayList<String>();
    }
    :   ENUM enumName=Identifier ('implements' tl=typeList { ic = tl; } )?
        {
            if (!isInCompoundStatement()) {
                getModeller().addEnumeration($enumName.text, modifiers,
                    ic, javadoc, (parserMode == MODE_IMPORT_PASS2));
            }
        }
        // now parse the body of the enum
        enumBody
        {
            getModeller().popClassifier();
        }
    ;

enumBody
    :   '{' enumConstants? ','? enumBodyDeclarations? '}'
    ;

enumConstants
    :   enumConstant (',' enumConstant)*
    ;

enumConstant
    :   annotations?
        name=Identifier
        {
            getModeller().addEnumerationLiteral($name.text);
        }
        // TODO: How do we model an enum constants argument?
        // EnterpriseArchitect appears to put it in a tagged value
        (arguments)?
        (classBody)?
    ;

enumBodyDeclarations
    :   ';' (classBodyDeclaration)*
    ;
    
// Declaration of a Java Interface
interfaceDeclaration[String javadoc, short modifiers]
    :   normalInterfaceDeclaration[javadoc, modifiers]
    |   annotationTypeDeclaration[javadoc, modifiers]
    ;

normalInterfaceDeclaration[String javadoc, short modifiers]
    @init{
        List<String> names = new ArrayList<String>();
    }
    :   'interface' interfaceName=Identifier (tparam=typeParameters)?
        ('extends' ie=typeList { names = ie; } )?
        {
            getModeller().addInterface($interfaceName.text, modifiers,
                tparam, names, javadoc, (parserMode == MODE_IMPORT_PASS2));
        }
        // now parse the body of the interface (looks like a class...)
        interfaceBody
        {
            getModeller().popClassifier();
        }
    ;

typeList returns [List<String> names = new ArrayList<String>()]
    :   n=type       { names.add(n); }
        ( ',' n=type { names.add(n); }
        )*
    ;

// This is the body of a class. Also used for the body of an enum constant.
classBody
    :   '{' classBodyDeclaration* '}'
    ;
    
interfaceBody
    :   '{' interfaceBodyDeclaration* '}'
    ;

classBodyDeclaration
    :   ';'
    |   'static'? block
    |   m=modifiers memberDecl[m]
    ;
    
memberDecl[short modifiers]
    :   genericMethodOrConstructorDecl[modifiers]
    |   memberDeclaration[modifiers]
    |   'void' name=Identifier voidMethodDeclaratorRest[$name.text, modifiers]
    |   name=Identifier constructorDeclaratorRest[$name.text, modifiers]
    |   interfaceDeclaration[getJavadocComment(), modifiers]
    |   classDeclaration[getJavadocComment(), modifiers]
    ;
    
memberDeclaration[short modifiers]
    :   t=type
        (   methodDeclaration[modifiers, null, t]
        |   fieldDeclaration[modifiers, t]
        )
    ;

genericMethodOrConstructorDecl[short modifiers]
    :   tparam=typeParameters genericMethodOrConstructorRest[modifiers, tparam]
    ;

genericMethodOrConstructorRest[short modifiers, List<String> tparam]
    @init{
        String t = null;
    }
    :   (ty=type { t = ty; } | 'void' { t = "void"; } )
        name=Identifier
        methodDeclaratorRest[$name.text, modifiers, tparam, t]
    |   name=Identifier
        constructorDeclaratorRest[$name.text, modifiers]
    ;

methodDeclaration[short modifiers, List<String> tparam, String t]
    :   name=Identifier methodDeclaratorRest[$name.text, modifiers, tparam, t]
    ;

fieldDeclaration[short modifiers, String t]
    :   variableDeclarators[getJavadocComment(), modifiers, t] ';'
    ;
        
interfaceBodyDeclaration
    :   m=modifiers interfaceMemberDecl[m]
    |   ';'
    ;

interfaceMemberDecl[short modifiers]
    :   interfaceMethodOrFieldDecl[modifiers]
    |   interfaceGenericMethodDecl[modifiers]
    |   'void' name=Identifier
        voidInterfaceMethodDeclaratorRest[$name.text, modifiers]
    |   interfaceDeclaration[getJavadocComment(), modifiers]
    |   classDeclaration[getJavadocComment(), modifiers]
    ;

interfaceMethodOrFieldDecl[short modifiers]
    :   t=type name=Identifier
        interfaceMethodOrFieldRest[$name.text, modifiers, t]
    ;

interfaceMethodOrFieldRest[String name, short modifiers, String t]
    :   constantDeclaratorsRest[getJavadocComment(), name, modifiers, t] ';'
    |   interfaceMethodDeclaratorRest[name, modifiers, null, t]
    ;

methodDeclaratorRest[String name, short modifiers, List<String> tparam, String t]
    @init{
        StringBuffer sb = new StringBuffer(t);
        boolean isOutestCompStat = !isInCompoundStatement();
    }
    :   param=formalParameters ('[' ']' { sb.append("[]"); } )*
        ('throws' qualifiedNameList)?
        (   methodBody
        |   ';'
        )
        // add a new operation to the model
        {
            if (isOutestCompStat && level > 0) {
                setMethod(getModeller().addOperation(modifiers, tparam,
                    sb.toString(), name, param, getJavadocComment(),
                    (parserMode == MODE_IMPORT_PASS2)));
                getModeller().addBodyToOperation(getMethod(),
                    (level > 1 ? getBody() : ""));
                setMethod(null);
                setBody(null);
            }
        }
    ;

voidMethodDeclaratorRest[String name, short modifiers]
    @init{
        boolean isOutestCompStat = !isInCompoundStatement();
    }
    :   param=formalParameters ('throws' qualifiedNameList)?
        (   methodBody
        |   ';'
        )
        // add a new operation with return type void to the model
        {
            if (isOutestCompStat && level > 0) {
                setMethod(getModeller().addOperation(modifiers, null,
                    "void", name, param, getJavadocComment(),
                    (parserMode == MODE_IMPORT_PASS2)));
                getModeller().addBodyToOperation(getMethod(),
                    (level > 1 ? getBody() : ""));
                setMethod(null);
                setBody(null);
            }
        }
    ;

interfaceMethodDeclaratorRest[String name, short modifiers, List<String> tparam, String t]
    @init{
        StringBuffer sb = new StringBuffer(t);
        boolean isOutestCompStat = !isInCompoundStatement();
    }
    :   param=formalParameters ('[' ']' { sb.append("[]"); } )*
        ('throws' qualifiedNameList)?
        ';'
        // add a new interface operation to the model
        {
            if (isOutestCompStat && level > 0) {
                setMethod(getModeller().addOperation(modifiers, tparam,
                    sb.toString(), name, param, getJavadocComment(),
                    (parserMode == MODE_IMPORT_PASS2)));
                setMethod(null);
            }
        }
    ;

interfaceGenericMethodDecl[short modifiers]
    @init{
        String t = null;
    }
    :   tparam=typeParameters (ty=type { t = ty; } | 'void' { t = "void"; } )
        name=Identifier
        interfaceMethodDeclaratorRest[$name.text, modifiers, tparam, t]
    ;

voidInterfaceMethodDeclaratorRest[String name, short modifiers]
    @init{
        boolean isOutestCompStat = !isInCompoundStatement();
    }
    :   param=formalParameters ('throws' qualifiedNameList)?
        ';'
        // add a new interface operation with return type void to the model
        {
            if (isOutestCompStat && level > 0) {
                setMethod(getModeller().addOperation(modifiers, null,
                    "void", name, param, getJavadocComment(),
                    (parserMode == MODE_IMPORT_PASS2)));
                setMethod(null);
            }
        }
    ;

constructorDeclaratorRest[String name, short modifiers]
    @init{
        boolean isOutestCompStat = !isInCompoundStatement();
    }
    :   param=formalParameters
        {
            if (isOutestCompStat && level > 0) {
                setMethod(getModeller().addOperation(modifiers,
                null, null, name, param, getJavadocComment(),
                (parserMode == MODE_IMPORT_PASS2)));
            }
        }
        ('throws' qualifiedNameList)?
        constructorBody
        // add a new constructor operation to the model
        {
            if (isOutestCompStat && level > 0) {
                getModeller().addBodyToOperation(getMethod(),
                    level > 1 ? getBody() : "");
                setMethod(null);
                setBody(null);
            }
        }
    ;

constantDeclarator[String javadoc, short modifiers, String t]
    @init{
        String name = null;
    }
    :   id=Identifier { name = $id.text; }
        constantDeclaratorRest[javadoc, name, modifiers, t]
    ;

variableDeclarators[String javadoc, short modifiers, String t]
    :   variableDeclarator[javadoc, modifiers, t]
        (',' variableDeclarator[javadoc, modifiers, t])*
    ;

variableDeclarator[String javadoc, short modifiers, String t]
    @init{
        String b = "";
        String id = null;
        int ix;
        String init = null;
    }
    :   vdi=variableDeclaratorId
        {
            id = $vdi.text;
            ix = id.indexOf('[');
            if (ix > 0) {
                b = id.substring(ix);
                id = id.substring(0, ix - 1);
            }
        }
        (
            {
                if ((parserMode & MODE_REVENG_SEQUENCE) != 0
                    && "new".equals(input.LT(2).getText())) {
                    createdObjectVarName = input.LT(0).getText();
                }
            }
            eqvi = equalsVariableInitializer
            {
                init = $eqvi.text.substring(1);
                createdObjectVarName = null;
            }
        )?
        {
            if (!isInCompoundStatement() && level > 0) {
                getModeller().addAttribute(modifiers, t + b, id, init, javadoc,
                    (parserMode == MODE_IMPORT_PASS2));
            }
            if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
                getModeller().addLocalVariableDeclaration(t + b, id);
            }
        }
    ;

constantDeclaratorsRest[String javadoc, String name, short modifiers, String t]
    :   constantDeclaratorRest[javadoc, name, modifiers, t]
        (',' constantDeclarator[javadoc, modifiers, t])*
    ;

constantDeclaratorRest[String javadoc, String name, short modifiers, String t]
    @init{
        StringBuffer sb = new StringBuffer(t);
        String trackedSoFar = null;
        String init = null;
    }
    :   ('[' ']' { sb.append("[]"); } )*
        {
            if ((parserMode & MODE_REVENG_SEQUENCE) != 0
                && "new".equals(input.LT(2).getText())) {
                createdObjectVarName = input.LT(0).getText();
            }
        }
        eqvi = equalsVariableInitializer
        {
            init = $eqvi.text.substring(1);
            createdObjectVarName = null;
            if (!isInCompoundStatement() && level > 0) {
                getModeller().addAttribute(modifiers, sb.toString(), name,
                    init, javadoc, (parserMode == MODE_IMPORT_PASS2));
            }
            if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
                getModeller().addLocalVariableDeclaration(sb.toString(), name);
            }
        }
    ;

variableDeclaratorId
    :   Identifier ('[' ']')*
    ;

equalsVariableInitializer
    :   
        '=' variableInitializer
    ;

variableInitializer
    :   arrayInitializer
    |   expression
    ;
        
arrayInitializer
    :   '{' (variableInitializer (',' variableInitializer)* (',')? )? '}'
    ;

modifier returns [short m = 0]
    :   annotation
    |   'public'       { m = ACC_PUBLIC; }
    |   'protected'    { m = ACC_PROTECTED; }
    |   'private'      { m = ACC_PRIVATE; }
    |   'static'       { m = ACC_STATIC; }
    |   'abstract'     { m = ACC_ABSTRACT; }
    |   'final'        { m = ACC_FINAL; }
    |   'native'       { m = ACC_NATIVE; }
    |   'synchronized' { m = ACC_SYNCHRONIZED; }
    |   'transient'    { m = ACC_TRANSIENT; }
    |   'volatile'     { m = ACC_VOLATILE; }
    |   'strictfp'
    ;

packageOrTypeName
    :   qualifiedName
    ;

enumConstantName
    :   Identifier
    ;

typeName
    :   qualifiedName
    ;

type returns [String t = null]
    @init{
        StringBuffer sb = new StringBuffer();
    }
    :   (
            coit=classOrInterfaceType { sb.append(coit); }
            ('[' ']'                  { sb.append("[]"); }
            )*
        |   pt=primitiveType          { sb.append($pt.text); }
            ('[' ']'                  { sb.append("[]"); }
            )*
        )
        {
            t = sb.toString();
        }
    ;

classOrInterfaceType returns [String t = null]
    @init{
        StringBuffer sb = new StringBuffer();
        // TODO: type arguments not currently returned
        List<String> ta = null;
    }
    :   t1=Identifier (typeArguments)?    { sb.append($t1.text); }
        (   '.' t3=Identifier { sb.append('.').append($t3.text); }
            (ta=typeArguments)?
        )*
        {
            t = sb.toString();
        }
    ;

primitiveType
    :   'boolean'
    |   'char'
    |   'byte'
    |   'short'
    |   'int'
    |   'long'
    |   'float'
    |   'double'
    ;

variableModifier returns [short m = 0]
    :   'final' { m = ACC_FINAL; }
    |   annotation
    ;

typeArguments
    :   '<' typeArgument (',' typeArgument)* '>'
    ;
    
typeArgument
    :   type
    |   '?' (('extends' | 'super') type)?
    ;
    
qualifiedNameList
    :   qualifiedName (',' qualifiedName)*
    ;

formalParameters returns [List<ParameterDeclaration> paramList=new ArrayList<ParameterDeclaration>()]
    :   '(' (formalParameterDecls[paramList])? ')'
    ;
    
formalParameterDecls[List<ParameterDeclaration> paramList]
    :   mods=variableModifiers t=type formalParameterDeclsRest[mods, t, paramList]
    ;
    
formalParameterDeclsRest[short mods, String t, List<ParameterDeclaration> paramList]
@init{
    String pdb = "";
    String id = null;
    int ix;
}
    :   vdi=variableDeclaratorId
        {
            id = $vdi.text;
            ix = id.indexOf('[');
            if (ix > 0) {
                pdb = id.substring(ix);
                id = id.substring(0, ix - 1);
            }
            paramList.add(new ParameterDeclaration(mods, t + pdb, id));
        }
        (',' formalParameterDecls[paramList])?
    |   '...' vdi=variableDeclaratorId
        {
            id = $vdi.text;
            ix = id.indexOf('[');
            if (ix > 0) {
                pdb = id.substring(ix);
                id = id.substring(0, ix - 1);
            }
            paramList.add(new ParameterDeclaration(mods, t + "..." + pdb, id));
        }
    ;
    
methodBody
    :   block
    ;

constructorBody
    @init{
        boolean isOutestCompStat = !isInCompoundStatement();
    }
    :   {
            if (isOutestCompStat) {
                setIsInCompoundStatement(true);
            }
        }
        '{' explicitConstructorInvocation? blockStatement* '}'
        {
            if (isOutestCompStat) {
                String b = $text;
                // the body is everything between { and }, but for
                // compatibility reasons the last ws's get stripped off
                // and a newline is added
                b = b.substring(0, b.length() - 1).trim();
                setBody(b.substring(1) + '\n');
                setIsInCompoundStatement(false);
            }
        }
    ;

explicitConstructorInvocation
    :   (nonWildcardTypeArguments)? ('this' | 'super') arguments ';'
    |   primary '.' nonWildcardTypeArguments? 'super' arguments ';'
    ;


qualifiedName
    :   Identifier ('.' Identifier)*
    ;
    
literal 
    :   integerLiteral
    |   FloatingPointLiteral
    |   CharacterLiteral
    |   StringLiteral
    |   booleanLiteral
    |   'null'
    ;

integerLiteral
    :   HexLiteral
    |   OctalLiteral
    |   DecimalLiteral
    ;

booleanLiteral
    :   'true'
    |   'false'
    ;

// ANNOTATIONS

annotations
    :   annotation+
    ;

annotation
    :   '@' an=annotationName
        {
            getModeller().addAnnotation($an.text);
        }
        ( '(' ( elementValuePairs | elementValue )? ')' )?
        {
            getModeller().endAnnotation();
        }
    ;

annotationName
    : Identifier ('.' Identifier)*
    ;

elementValuePairs
    :   elementValuePair (',' elementValuePair)*
    ;

elementValuePair
    :   Identifier '=' elementValue
    ;
    
elementValue
    :   conditionalExpression
    |   annotation
    |   elementValueArrayInitializer
    ;

elementValueArrayInitializer
    :   '{' (elementValue (',' elementValue)*)? (',')? '}'
    ;

annotationTypeDeclaration[String javadoc, short modifiers]
    :   '@' 'interface' name=Identifier
        {
            getModeller().addAnnotationDefinition(name.getText(), modifiers,
                javadoc, (parserMode == MODE_IMPORT_PASS2));
        }
        annotationTypeBody
        // TODO: need a popClassifier or perhaps endAnnotationDefinintion here
    ;

annotationTypeBody
    :   '{' (annotationTypeElementDeclaration)* '}'
    ;

annotationTypeElementDeclaration
    :   modifiers annotationTypeElementRest
    ;

annotationTypeElementRest
    :   type annotationMethodOrConstantRest ';'
    |   normalClassDeclaration[null, (short)0] ';'?
    |   normalInterfaceDeclaration[null, (short)0] ';'?
    |   enumDeclaration[null, (short)0] ';'?
    |   annotationTypeDeclaration[null, (short)0] ';'?
    ;

annotationMethodOrConstantRest
    :   annotationMethodRest
    |   annotationConstantRest
    ;
    
annotationMethodRest
    :   Identifier '(' ')' (defaultValue)?
    ;
    
annotationConstantRest
    :   variableDeclarators["", (short)0, null]
    ;
    
defaultValue
    :   'default' elementValue
    ;

// STATEMENTS / BLOCKS

block
    @init{
        boolean isOutestCompStat = !isInCompoundStatement();
    }
    :   {
            if (isOutestCompStat) {
                setIsInCompoundStatement(true);
            }
        }
        '{' blockStatement* '}'
        {
            if (isOutestCompStat) {
                String b = $text;
                // the body is everything between { and }, but for
                // compatibility reasons the last ws's get stripped off
                // and a newline is added
                b = b.substring(0, b.length() - 1).trim();
                setBody(b.substring(1) + '\n');
                setIsInCompoundStatement(false);
            }
        }
    ;
    
blockStatement
    :   localVariableDeclarationStatement
    |   classOrInterfaceDeclaration
    |   statement
    ;
    
localVariableDeclarationStatement
    :    localVariableDeclaration ';'
    ;

localVariableDeclaration
    :   variableModifiers type variableDeclarators["", (short)0, null]
    ;
    
variableModifiers returns [short mods = 0]
    :   (m=variableModifier { mods |= m; } )*
    ;

statement
    : block
    |   ASSERT expression (':' expression)? ';'
    |   'if' parExpression statement (options {k=1;}:'else' statement)?
    |   'for' '(' forControl ')' statement
    |   'while' parExpression statement
    |   'do' statement 'while' parExpression ';'
    |   'try' block
        ( catches 'finally' block
        | catches
        |   'finally' block
        )
    |   'switch' parExpression '{' switchBlockStatementGroups '}'
    |   'synchronized' parExpression block
    |   'return' expression? ';'
    |   'throw' expression ';'
    |   'break' Identifier? ';'
    |   'continue' Identifier? ';'
    |   ';' 
    |   statementExpression ';'
    |   Identifier ':' statement
    ;
    
catches
    :   catchClause (catchClause)*
    ;
    
catchClause
    :   'catch' '(' formalParameter ')' block
    ;

formalParameter
    :   variableModifiers type variableDeclaratorId
    ;
        
switchBlockStatementGroups
    :   (switchBlockStatementGroup)*
    ;
    
/* The change here (switchLabel -> switchLabel+) technically makes this grammar
   ambiguous; but with appropriately greedy parsing it yields the most
   appropriate AST, one in which each group, except possibly the last one, has
   labels and statements. */
switchBlockStatementGroup
    :   switchLabel+ blockStatement*
    ;
    
switchLabel
    :   'case' constantExpression ':'
    |   'case' enumConstantName ':'
    |   'default' ':'
    ;
    
forControl
options {k=3;} // be efficient for common case: for (ID ID : ID) ...
    :   enhancedForControl
    |   forInit? ';' expression? ';' forUpdate?
    ;

forInit
    :   localVariableDeclaration
    |   expressionList
    ;
    
enhancedForControl
    :   variableModifiers type Identifier ':' expression
    ;

forUpdate
    :   expressionList
    ;

// EXPRESSIONS

parExpression
    :   '(' expression ')'
    ;
    
expressionList
    :   expression (',' expression)*
    ;

statementExpression
    :   expression
        //TODO: addCall somewhere, please!
    ;
    
constantExpression
    :   expression
    ;
    
expression
    :   conditionalExpression (assignmentOperator expression)?
    ;
    
assignmentOperator
    :   '='
    |   '+='
    |   '-='
    |   '*='
    |   '/='
    |   '&='
    |   '|='
    |   '^='
    |   '%='
    |   ('<' '<' '=')=> t1='<' t2='<' t3='=' 
        { $t1.getLine() == $t2.getLine() &&
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() && 
          $t2.getLine() == $t3.getLine() && 
          $t2.getCharPositionInLine() + 1 == $t3.getCharPositionInLine() }?
    |   ('>' '>' '>' '=')=> t1='>' t2='>' t3='>' t4='='
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() &&
          $t2.getLine() == $t3.getLine() && 
          $t2.getCharPositionInLine() + 1 == $t3.getCharPositionInLine() &&
          $t3.getLine() == $t4.getLine() && 
          $t3.getCharPositionInLine() + 1 == $t4.getCharPositionInLine() }?
    |   ('>' '>' '=')=> t1='>' t2='>' t3='='
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() && 
          $t2.getLine() == $t3.getLine() && 
          $t2.getCharPositionInLine() + 1 == $t3.getCharPositionInLine() }?
    ;

conditionalExpression
    :   conditionalOrExpression ( '?' expression ':' expression )?
    ;

conditionalOrExpression
    :   conditionalAndExpression ( '||' conditionalAndExpression )*
    ;

conditionalAndExpression
    :   inclusiveOrExpression ( '&&' inclusiveOrExpression )*
    ;

inclusiveOrExpression
    :   exclusiveOrExpression ( '|' exclusiveOrExpression )*
    ;

exclusiveOrExpression
    :   andExpression ( '^' andExpression )*
    ;

andExpression
    :   equalityExpression ( '&' equalityExpression )*
    ;

equalityExpression
    :   instanceOfExpression ( ('==' | '!=') instanceOfExpression )*
    ;

instanceOfExpression
    :   relationalExpression ('instanceof' type)?
    ;

relationalExpression
    :   shiftExpression ( relationalOp shiftExpression )*
    ;
    
relationalOp
    :   ('<' '=')=> t1='<' t2='=' 
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() }?
    |   ('>' '=')=> t1='>' t2='=' 
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() }?
    |   '<' 
    |   '>' 
    ;

shiftExpression
    :   additiveExpression ( shiftOp additiveExpression )*
    ;

shiftOp
    :   ('<' '<')=> t1='<' t2='<' 
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() }?
    |   ('>' '>' '>')=> t1='>' t2='>' t3='>' 
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() &&
          $t2.getLine() == $t3.getLine() && 
          $t2.getCharPositionInLine() + 1 == $t3.getCharPositionInLine() }?
    |   ('>' '>')=> t1='>' t2='>'
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() }?
    ;


additiveExpression
    :   multiplicativeExpression ( ('+' | '-') multiplicativeExpression )*
    ;

multiplicativeExpression
    :   unaryExpression ( ( '*' | '/' | '%' ) unaryExpression )*
    ;
    
unaryExpression
    :   '+' unaryExpression
    |   '-' unaryExpression
    |   '++' unaryExpression
    |   '--' unaryExpression
    |   unaryExpressionNotPlusMinus
    ;

unaryExpressionNotPlusMinus
    :   '~' unaryExpression
    |   '!' unaryExpression
    |   castExpression
    |   primary selector* ('++'|'--')?
    ;

castExpression
    :  '(' primitiveType ')' unaryExpression
    |  '(' (type | expression) ')' unaryExpressionNotPlusMinus
    ;

primary
    @init{
        String name = null;
        boolean parenths = false; //LA(1) == LPAREN;
    }
    :   parExpression
    |   'this' ('.' id=Identifier { name = $id.text; } )*
        (identifierSuffix { parenths = true; } )?
        { if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
              addDotCall(name, "this.", parenths);
          }
        }
    |   'super' superSuffix
        { if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
              addDotCall(name, "super.", true);
          }
        }
    |   literal
    |   'new' creator
    |   id=Identifier  { name = $id.text; }
        ('.' id=Identifier { name = $id.text; } )*
        (identifierSuffix { parenths = true; } )?
        { if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
              addDotCall(name, null, parenths);
          }
        }
    |   primitiveType ('[' ']')* '.' 'class'
    |   'void' '.' 'class'
    ;

identifierSuffix
    :   ('[' ']')+ '.' 'class'
    |   ('[' expression ']')+ // can also be matched by selector, but do here
    |   arguments
    |   '.' 'class'
    |   '.' explicitGenericInvocation
    |   '.' 'this'
    |   '.' 'super' arguments
    |   '.' 'new' innerCreator
    ;

creator
    :   nonWildcardTypeArguments t=createdName classCreatorRest[$t.text]
    |   t=createdName (arrayCreatorRest | classCreatorRest[$t.text])
    ;

createdName
    :   classOrInterfaceType
    |   primitiveType
    ;
    
innerCreator
    :   (nonWildcardTypeArguments)? t=Identifier classCreatorRest[$t.text]
    ;

arrayCreatorRest
    :   '['
        (   ']' ('[' ']')* arrayInitializer
        |   expression ']' ('[' expression ']')* ('[' ']')*
        )
    ;

classCreatorRest[String t]
    :   arguments
        { if ((parserMode & MODE_REVENG_SEQUENCE) != 0) {
            StringBuffer sb = new StringBuffer();
            if (";".equals(input.LT(1).getText()) && createdObjectVarName != null) {
              sb.append(createdObjectVarName).append('=');
            }
            sb.append("new ").append(t);
            getModeller().addCall(sb.toString());
          }
        }
        (
            {
                getModeller().addAnonymousClass(t,
                    (parserMode == MODE_IMPORT_PASS2));
            }
            classBody
            {
                getModeller().popClassifier();
            }
        )?
    ;
    
explicitGenericInvocation
    :   nonWildcardTypeArguments Identifier arguments
    ;
    
nonWildcardTypeArguments
    :   '<' typeList '>'
    ;
    
selector
    :   '.' Identifier (arguments)?
    |   '.' 'this'
    |   '.' 'super' superSuffix
    |   '.' 'new' innerCreator
    |   '[' expression ']'
    ;
    
superSuffix
    :   arguments
    |   '.' Identifier (arguments)?
    ;

arguments
    :   '(' expressionList? ')'
    ;

// LEXER

HexLiteral : '0' ('x'|'X') HexDigit+ IntegerTypeSuffix? ;

DecimalLiteral : ('0' | '1'..'9' '0'..'9'*) IntegerTypeSuffix? ;

OctalLiteral : '0' ('0'..'7')+ IntegerTypeSuffix? ;

fragment
HexDigit : ('0'..'9'|'a'..'f'|'A'..'F') ;

fragment
IntegerTypeSuffix : ('l'|'L') ;

FloatingPointLiteral
    :   ('0'..'9')+ '.' ('0'..'9')* Exponent? FloatTypeSuffix?
    |   '.' ('0'..'9')+ Exponent? FloatTypeSuffix?
    |   ('0'..'9')+ Exponent FloatTypeSuffix?
    |   ('0'..'9')+ FloatTypeSuffix
    ;

fragment
Exponent : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;

fragment
FloatTypeSuffix : ('f'|'F'|'d'|'D') ;

CharacterLiteral
    :   '\'' ( EscapeSequence | ~('\''|'\\') ) '\''
    ;

StringLiteral
    :  '"' ( EscapeSequence | ~('\\'|'"') )* '"'
    ;

fragment
EscapeSequence
    :   '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\')
    |   UnicodeEscape
    |   OctalEscape
    ;

fragment
OctalEscape
    :   '\\' ('0'..'3') ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7')
    ;

fragment
UnicodeEscape
    :   '\\' 'u' HexDigit HexDigit HexDigit HexDigit
    ;

ENUM:   'enum' {if (!enumIsKeyword) $type=Identifier;}
    ;
    
ASSERT
    :   'assert' {if (!assertIsKeyword) $type=Identifier;}
    ;
    
Identifier 
    :   Letter (Letter|JavaIDDigit)*
    ;

/* I found this char range in JavaCC's grammar, but Letter and Digit overlap.
   Still works, but...
 */
fragment
Letter
    :  '\u0024' |
       '\u0041'..'\u005a' |
       '\u005f' |
       '\u0061'..'\u007a' |
       '\u00c0'..'\u00d6' |
       '\u00d8'..'\u00f6' |
       '\u00f8'..'\u00ff' |
       '\u0100'..'\u1fff' |
       '\u3040'..'\u318f' |
       '\u3300'..'\u337f' |
       '\u3400'..'\u3d2d' |
       '\u4e00'..'\u9fff' |
       '\uf900'..'\ufaff'
    ;

fragment
JavaIDDigit
    :  '\u0030'..'\u0039' |
       '\u0660'..'\u0669' |
       '\u06f0'..'\u06f9' |
       '\u0966'..'\u096f' |
       '\u09e6'..'\u09ef' |
       '\u0a66'..'\u0a6f' |
       '\u0ae6'..'\u0aef' |
       '\u0b66'..'\u0b6f' |
       '\u0be7'..'\u0bef' |
       '\u0c66'..'\u0c6f' |
       '\u0ce6'..'\u0cef' |
       '\u0d66'..'\u0d6f' |
       '\u0e50'..'\u0e59' |
       '\u0ed0'..'\u0ed9' |
       '\u1040'..'\u1049'
   ;

WS  :   (' '|'\r'|'\t'|'\u000C'|'\n')
        {
            $channel=HIDDEN;
        }
    ;

// Empty comment block needs to be distinguished from Javadoc
EMPTY_COMMENT
    :    '/**/'
        {
            $channel=HIDDEN;
        }
    ;

// javadoc comments
JAVADOC
    :   '/**' ( options {greedy=false;} : . )* '*/'
        {
            $channel=HIDDEN;
        }
    ;

// multiple-line comments
COMMENT
    :   '/*' ~'*' ( options {greedy=false;} : . )* '*/'
        {
            $channel=HIDDEN;
        }
    ;

// single-line comments
LINE_COMMENT
    :   '//' ~('\n'|'\r')* '\r'? '\n'
        {
            $channel=HIDDEN;
        }
    ;
