// $Id: PropPanelFactory.java 14564 2008-05-01 19:20:21Z mvw $
// Copyright (c) 2008 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies. This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason. IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.uml.ui;

/**
 * Interface for a factory of proppanels, 
 * which are created based on a given object.
 *
 * @author Michiel
 */
public interface PropPanelFactory {

    /**
     * This method shall test the type of the given object,
     * and if recognised, create a new instance of a PropPanel. <p>
     * 
     * If the object type is not something this factory 
     * knows how to deal with, then null shall be returned
     * (do NOT throw an exception). <p>
     * 
     * If the given object falls within a class of objects 
     * that this factory is the exclusive factory for,
     * then it is allowed to throw an exception if 
     * the object is invalid/unknown. However,
     * be careful not to break the possibility to extend ArgoUML.  
     *  
     * @param object the object to create a new PropPanel for
     * @return the new proppanel or null
     */
    PropPanel createPropPanel(Object object);
}
