// $Id: FigMessageComparator.java 16381 2008-12-19 15:37:46Z bobtarling $
// Copyright (c) 2007 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies. This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason. IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.sequence2.diagram;

import java.util.Comparator;

/**
 * Compares two figmessages. 
 * The bigger one is that which Y start is lowest.
 * @author penyaskito
 */
class FigMessageComparator implements Comparator<FigMessage> {

    /**
     * @param m1 The first FigMessage
     * @param m2 The second one
     * @return x > 0, if m1.y < m2.y
     *         x < 0, if m1.y > m2.y
     *         x = 0, if m1.y = m2.y
     * @see java.util.Comparator#compare
     */
    public int compare(FigMessage m1, FigMessage m2) {
        int result = 0;
        if (m1.getFinalY() < m2.getFinalY()) {
            result = -1;
        }
        else if (m1.getFinalY() > m2.getFinalY()) {
            result = 1;
        }
        return result;
    }

}
